﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CashierCrisis.Entities
{
    public class CollisionComponent : Component
    {
        public float Radius { get; set; }

        public CollisionComponent(string name)
            : base(name)
        {

        }

        public bool Collide(Entity entity)
        {
            CollisionComponent b = entity.GetComponent("collision") as CollisionComponent;

            float x = Entity.Position.X - b.Entity.Position.X;
            float y = Entity.Position.Y - b.Entity.Position.Y;

            float squareDistance = (x * x) + (y * y);

            return (squareDistance < Radius + b.Radius);
        }

    }
}
